function [s_arr, center_arr, distance, h1_arr, h2_arr] = fuzzify(y_start, y_end, n, D, T)
	FDpp = 8;
	distance = (y_end - y_start) / n;
	s_arr = {};
	center_arr = zeros(n, 1);
	h1_arr = zeros(n, 1);
	h2_arr = zeros(n, 1);
	center_arr(1) = y_start + distance/2;
	for i = 2:n
		center_arr(i) = center_arr(i-1) + distance;
	end
	for i = 1:n
		F1pp = inv_stat(center_arr(i), FDpp, T);
		[h1pp, h2pp] = find_pp(F1pp, FDpp, 10000, T);
		h1_arr(i) = h1pp;
		h2_arr(i) = h2pp;
		s_u = step_lin(F1pp, h1pp, h2pp, FDpp, 1, D, T);
		s_u = s_u - s_u(1);
		s_arr{end+1} = s_u;
	end