addpath('D:\SerialCommunication'); % add a path to the functions
initSerialControl COM7 % initialise com port

%parametry
Upp = 27;
Ypp = 30;
Umin= 0;
Umax = 100;

kk=1000;

D = 300;
D_z = 300;
N =30;
Nu =15;

u(1:kk)=Upp; 
y(1:kk)=Ypp;

e(1:D-1)=0;
lambda = 0.15;
yzad(1:400)=30;
yzad(401:kk)= 40;
Z = zeros(1,kk);
Z(1:600) = 0;
Z(601:800) = 30;
Z(801:kk) = 0;
z = Z;


M = zeros(N,Nu);
Mp = zeros(N,D-1);
Mp_z = zeros(N,D_z-1);

% Wypełnianie macierzy M i Mp
for i= 1:N
    for j = 1:Nu
        if (i-j+1)>0
            M(i,j) = s(i-j+1);
        end
    end
end

for i = 1:N
    for j = 1:D-1
        Mp(i,j) = s(min(i+j,D)) - s(j);
    end
end

for i = 1:N
    for j = 1:D_z-1
        Mp_z(i,j) = sZ(min(i+j,D_z)) - sZ(j);
    end
end

Gamma = eye(N,N);
Alpha = eye(Nu,Nu) * lambda;

K = inv(M' * Gamma * M + Alpha) * M' * Gamma;

E = 0;
for k=D_z:kk
    y(k) = readMeasurements(1:1);
    e(k)=yzad(k)-y(k);
    E = E + e(k)^2;
    dUp = [];
    for i=1:D-1
        if (k-i-1) > 0
            dUp = [dUp;u(k-i) - u(k-i-1)];
        else
            dUp = [dUp;u(k-i)];
        end
    end
    dZp = [];
    for i=1:D_z-1
        if (k-i-1) > 0
            dZp = [dZp;z(k-i) - z(k-i-1)];
        else
            dZp = [dZp;z(k-i)];
        end
    end
    YzadN = yzad(k) *ones(N,1);
    YkN = y(k) *ones(N,1);
    dU = K*(YzadN - YkN - Mp * dUp - Mp_z * dZp);
    u(k)= dU(1) + u(k-1);
    if u(k) < Umin
        u(k) = Umin;
    end
    if u(k) > Umax
        u(k) = Umax;
    end
    sendControlsToG1AndDisturbance(u(k), z(k));
    waitForNewIteration();
    refreshdata
    drawnow
    stairs(y);
    hold on
    stairs(u);
    stairs(yzad);
    hold off;

end

E

% wykresy
t = linspace(1,kk,kk);
plot_data = [t', u'];
save("zadDMC5u_symN"+N+"Nu"+Nu+"D"+D+"LAM"+lambda+".txt","plot_data","-ascii")
plot_data = [t', y'];
save("zadDMC5y_symN"+N+"Nu"+Nu+"D"+D+"LAM"+lambda+".txt","plot_data","-ascii")
plot_data = [t', yzad'];
save("zadDMC5yzad_symN"+N+"Nu"+Nu+"D"+D+"LAM"+lambda+".txt","plot_data","-ascii")