function [u, y, e] = dmc_single(F1pp, h1pp, h2pp, s_u, yzad, D, FD, N, Nu, lambda, t, T)
    % Inicjalizacja wektorów
    tau = 150;
    n_samples = int32(t/T);
    k_delay = int32(tau/T);
    u = F1pp * ones(n_samples, 1);
    y = h2pp * ones(n_samples, 1);
    e = zeros(n_samples, 1);
    M = zeros(N, Nu);
    Mp = zeros(N,D-1);
    h1 = h1pp;
    h2 = h2pp;
    % Macierz M
    for i = 1:N
        for j = 1:Nu
            if (i-j+1) > 0
                M(i,j) = s_u(i-j+1);
            end
        end
    end
    % Macierz Mpu
    for i = 1:N
        for j = 1:D-1
            Mp(i,j) = s_u(min(i+j,D)) - s_u(j);
        end
    end

    % Wyznaczenie K i dobranie parametrów kary
    Lambda = eye(Nu, Nu) * lambda;
    K = inv(M' * M + Lambda) * M' * eye(N, N);
    T = 1;
    % Główna pętla regulatora
    for k = 1:n_samples
        k
        F1 = F1pp;
        if k - k_delay > 0
            F1 = u(k-k_delay);
        end
        dUp = [];
        [h1, h2, V1, V2, F2, F3] = simulate(h1, h2, FD(k), F1, T);
        y(k) = h2;
        e(k) = yzad(k) - y(k);
        Yzadk = yzad(k) * ones(N, 1);
        Yk = y(k) * ones(N, 1);
        for i = 1:D-1
            dUp = [dUp; u(max(k-i, 1)) - u(max(k-i-1, 1))];
        end
        dU = K * (Yzadk - Yk - Mp * dUp);
        if k - 1 > 0
            u(k) = dU(1) + u(k-1);
        else
            u(k) = dU(1) + F1pp;
        end
    end
end