function [u, y, e] = dmc_fuzzy(Upp, Ypp, s_u_arr, yzad, N, Nu, lambda_arr, t, T)
    u_min = 0;
    u_max = 100;
    % Inicjalizacja wektorów
    n_samples = int32(t/T);
    u = Upp * ones(n_samples, 1);
    y = Ypp * ones(n_samples, 1);
    e = zeros(n_samples, 1);
    n = length(s_u_arr);

    M_arr = {};
    Mp_arr = {};
    K_arr = {};
    for i_M = 1:n
        M = zeros(N, Nu);
        Mp = zeros(N,800-1);
        % Macierz M
        for i = 1:N
            for j = 1:Nu
                if (i-j+1) > 0
                    M(i,j) = s_u_arr{i_M}(i-j+1);
                end
            end
        end
        M_arr{end + 1} = M;
        % Macierz Mpu
        for i = 1:N
            for j = 1:800-1
                Mp(i,j) = s_u_arr{i_M}(min(i+j,800)) - s_u_arr{i_M}(j);
            end
        end
        Mp_arr{end + 1} = Mp;

        Lambda = eye(Nu, Nu) * lambda_arr(i_M);
        K = inv(M' * M + Lambda) * M' * eye(N, N);
        K_arr{end+1} = K;
    end

    % Wyznaczenie K i dobranie parametrów kary
    T = 1;
    % Główna pętla regulatora
    for k = 1:n_samples
        przyn_arr = zeros(size(s_u_arr));
        if y(max(k-1, 1)) < 34
            przyn_arr(1) = 1;
        elseif y(max(k-1, 1)) > 50.37
            przyn_arr(n) = 1;
        elseif y(max(k-1, 1)) < 42.93
            przyn_arr(1) = (y(max(k-1, 1)) - 34) / (42.93 - 34);
            przyn_arr(2) = (42.93 - y(max(k-1, 1))) / (42.93 - 34);
        else
            przyn_arr(2) = (y(max(k-1, 1)) - 42.93) / (50.37 - 42.93);
            przyn_arr(3) = (50.37 - y(max(k-1, 1))) / (50.37 - 42.93);
        end
        y(k) = readMeasurements(1:1);
        e(k) = yzad(k) - y(k);
        Yzadk = yzad(k) * ones(N, 1);
        Yk = y(k) * ones(N, 1);


        dU = zeros(Nu, 1);
        for i_K = 1:n
            dUp = [];
            for i = 1:800-1
                dUp = [dUp; u(max(k-i, 1)) - u(max(k-i-1, 1))];
            end
            dU = dU + przyn_arr(i_K) * K_arr{i_K} * (Yzadk - Yk - Mp_arr{i_K} * dUp);
        end
        if k - 1 > 0
            u(k) = dU(1) + u(k-1);
        else
            u(k) = dU(1) + Upp;
        end
        u(k) = min(max(u_min, u(k)), u_max);
        sendNonlinearControls(u(k));
        waitForNewIteration();
        refreshdata
        drawnow
        stairs(y);
        hold on;
        stairs(u);
        hold off;
    end
end