t = 10000;
T = 1;
F1pp = 52;
FDpp = 8;
[h1, h2] = find_pp(F1pp, FDpp, 10000, T);
n = 5;
D = 5000;
y_start = 2;
y_end = 20;
[s_arr, center_arr, distance, h1_arr, h2_arr] = fuzzify(y_start, y_end, n, D, T);
f_przyn = @przyn_sigmoid;
figure; hold on;

for delta = -26:13:26
    s=step(F1pp, h1, h2, FDpp, delta, t, T);
    plot(s, Color=[0 0.447 0.741])
    samples = 1:length(s);
    samples = samples';
    plot_data = [samples, s];
    save("sim/s_delta" + delta + ".txt", 'plot_data', '-ascii')
    sf=step_fuzzy(F1pp, h1, h2, FDpp, delta, t, T, f_przyn, center_arr, s_arr, distance);
    plot(sf, Color=[0.85 0.325 0.098])
    samples = 1:length(sf);
    samples = samples';
    plot_data = [samples, sf];
    save("sim/sf_delta" + delta + "_sigmoid_" + n + "poles.txt", 'plot_data', '-ascii')
    sl=step_lin(F1pp, h1, h2, FDpp, delta, t, T);
    plot(sl, Color=[0.929 0.694 0.125])
    samples = 1:length(sl);
    samples = samples';
    plot_data = [samples, sl];
    save("sim/sl_delta" + delta + ".txt", 'plot_data', '-ascii')
end
legend('Model nieliniowy','Model Takagi-Sugeno', 'Model liniowy')
xlabel("numer próbki - k")
ylabel("wysokość h_2")
print("sim/sf_delta" + delta + "_sigmoid_" + n + "poles.pdf",'-dpng','-r400')