function [h2]  = simulate_fuzzy(FD, F1_vec, D_arr, T, s_u_arr, h2_in, f_przyn, center_arr, distance)
	h2_in;
	n = length(center_arr);
	przyn_arr = zeros(size(center_arr));
	if h2_in < center_arr(1)
		przyn_arr(1) = 1;
	elseif h2_in > center_arr(n)
		przyn_arr(n) = 1;
	else
		for i = 1:n
			przyn_arr(i) = f_przyn(center_arr(i), distance, h2_in);
		end
	end

	h2 = 0;
	for i_pole = 1:n
        Mp = zeros(1,D_arr(i_pole)-1);
        % Macierz Mpu
        for j = 1:D_arr(i_pole)-1
            Mp(1,j) = s_u_arr{i_pole}(min(1+j,D_arr(i_pole))) - s_u_arr{i_pole}(j);
        end
		dUp = [];
        for i = 1:D_arr(i_pole)-1
            dUp = [dUp; F1_vec(max(D_arr(i_pole)-i, 1)) - F1_vec(max(D_arr(i_pole)-i-1, 1))];
        end
        h2 = h2 + (h2_in + Mp * dUp) * przyn_arr(i_pole);
	end
