function [u, y, e] = dmc_fuzzy(F1pp, h1pp, h2pp, s_u_arr, yzad, D_arr, FD, N, Nu, lambda_arr, t, T, f_przyn, center_arr, distance, u_min, u_max)
    % Inicjalizacja wektorów
    tau = 150;
    n_samples = int32(t/T);
    k_delay = int32(tau/T);
    u = F1pp * ones(n_samples, 1);
    y = h2pp * ones(n_samples, 1);
    e = zeros(n_samples, 1);
    h1 = h1pp;
    h2 = h2pp;
    n = length(s_u_arr);

    M_arr = {};
    Mp_arr = {};
    K_arr = {};
    for i_M = 1:n
        M = zeros(N, Nu);
        Mp = zeros(N,D_arr(i_M)-1);
        % Macierz M
        for i = 1:N
            for j = 1:Nu
                if (i-j+1) > 0
                    M(i,j) = s_u_arr{i_M}(i-j+1);
                end
            end
        end
        M_arr{end + 1} = M;
        % Macierz Mpu
        for i = 1:N
            for j = 1:D_arr(i_M)-1
                Mp(i,j) = s_u_arr{i_M}(min(i+j,D_arr(i_M))) - s_u_arr{i_M}(j);
            end
        end
        Mp_arr{end + 1} = Mp;

        Lambda = eye(Nu, Nu) * lambda_arr(i_M);
        K = inv(M' * M + Lambda) * M' * eye(N, N);
        K_arr{end+1} = K;
    end

    % Wyznaczenie K i dobranie parametrów kary
    T = 1;
    % Główna pętla regulatora
    for k = 1:n_samples
        k
        przyn_arr = zeros(size(center_arr));
        if y(max(k-1, 1)) < center_arr(1)
            przyn_arr(1) = 1;
        elseif y(max(k-1, 1)) > center_arr(n)
            przyn_arr(n) = 1;
        else
            for i = 1:n
                przyn_arr(i) = f_przyn(center_arr(i), distance, y(max(k-1, 1)));
            end
        end
        F1 = F1pp;
        if k - k_delay > 0
            F1 = u(k-k_delay);
        end
        [h1, h2, V1, V2, F2, F3] = simulate(h1, h2, FD(k), F1, T);
        y(k) = h2;
        e(k) = yzad(k) - y(k);
        Yzadk = yzad(k) * ones(N, 1);
        Yk = y(k) * ones(N, 1);


        dU = zeros(Nu, 1);
        for i_K = 1:n
            dUp = [];
            for i = 1:D_arr(i_K)-1
                dUp = [dUp; u(max(k-i, 1)) - u(max(k-i-1, 1))];
            end
            dU = dU + przyn_arr(i_K) * K_arr{i_K} * (Yzadk - Yk - Mp_arr{i_K} * dUp);
        end
        if k - 1 > 0
            u(k) = dU(1) + u(k-1);
        else
            u(k) = dU(1) + F1pp;
        end
        u(k) = min(max(u_min, u(k)), u_max);
    end
end