addpath('D:\SerialCommunication'); % add a path to the functions
initSerialControl COM7 % initialise com port

% parametry
Upp = 27;
Ypp = 30.5;
Umin= 0;
Umax = 100;
deltaumax = inf;
Tp=1;

kk=900; 
u=ones(kk,1) * Upp; 
y=ones(kk,1) * Ypp;
yzad=zeros(kk,1);
e(1:kk)=0;

t = 1:length(u);
t = t';

% parametry regulatora
Kp = [9, 12, 6];
Ti = [50, 50, 30];
Td = [1.5, 0.5, 1];

r2 = Kp.*Td./Tp;
r1 = Kp.*((Tp./(2.*Ti)) -2 .*(Td./Tp) -1);
r0 = Kp.*(1+(Tp./(2.*Ti)) + (Td./Tp));

yzad(1:150)=Ypp;
yzad(151:400) = Ypp+5;
yzad(401:650) = Ypp+15;
yzad(651:900) = Ypp;

E = 0;
for k=12:kk
    przyn_arr = zeros(1,3);
    if y(max(k-1, 1)) < 34
        przyn_arr(1) = 1;
    elseif y(max(k-1, 1)) > 50.37
        przyn_arr(n) = 1;
    elseif y(max(k-1, 1)) < 42.93
        przyn_arr(1) = (y(max(k-1, 1)) - 34) / (42.93 - 34);
        przyn_arr(2) = (42.93 - y(max(k-1, 1))) / (42.93 - 34);
    else
        przyn_arr(2) = (y(max(k-1, 1)) - 42.93) / (50.37 - 42.93);
        przyn_arr(3) = (50.37 - y(max(k-1, 1))) / (50.37 - 42.93);
    end

    y(k) = readMeasurements(1:1);
    disp(k);
    disp(y(k));
    disp(u(k-1));
    e(k)=yzad(k)-y(k);
    u_new=r2.*e(k-2)+r1.*e(k-1)+r0.*e(k)+u(k-1);
    u(k) = sum(u_new.*przyn_arr);
    E = E + e(k)^2;


    % sprawdzenie czy delta u nie przekracza wartości maksymalnej
    if abs(u(k) - u(k-1)) > deltaumax
        u(k) = u(k-1) + deltaumax * sign(u(k) - u(k-1));
    end

    % Sprawdzenie czy u(k) znajduje się w przedziale
    if u(k) < Umin
        u(k) = Umin;
    end
    if u(k) > Umax
        u(k) = Umax;
    end

    sendNonlinearControls(u(k));
    waitForNewIteration();
    refreshdata
    drawnow
    stairs(t,y);
    hold on;
    stairs(t,u);
    hold off;
end

% wykresy
figure; 
stairs(t,u);
plot_data = [t, u];
save("zadPid4u_sym.txt","plot_data","-ascii")
title('Przebieg sterowania'); 
xlabel('Numer próbki');
ylabel("Wartość sterowania")
figure
stairs(t,y); 
plot_data = [t, y];
save("zadPid4y_sym.txt","plot_data","-ascii")
hold on;
stairs(t,yzad);
plot_data = [t, yzad];
save("zadPid4yzad_sym.txt","plot_data","-ascii")
title('Przebieg y,y_{zad}'); 
xlabel('Numer próbki');
ylabel('Wartość wyjścia')
legend("Wartość na wyjściu", "Wartość zadana")

