function [u, y, e] = dmc_fuzzy(F1pp, h1pp, h2pp, s_u_arr, yzad, D, FD, N, Nu, lambda, t, T, f_przyn, center_arr, distance, u_min, u_max)
    % Inicjalizacja wektorów
    tau = 150;
    n_samples = int32(t/T);
    k_delay = int32(tau/T);
    u = F1pp * ones(n_samples, 1);
    y = h2pp * ones(n_samples, 1);
    e = zeros(n_samples, 1);
    h1 = h1pp;
    h2 = h2pp;
    n = length(s_u_arr);
    A = [-1 * triu(ones(Nu))'; 1 * triu(ones(Nu))'];

    % Wyznaczenie K i dobranie parametrów kary
    T = 1;
    % Główna pętla regulatora
    for k = 1:n_samples
        k
        przyn_arr = zeros(size(center_arr));
        if y(max(k-1, 1)) < center_arr(1)
            przyn_arr(1) = 1;
        elseif y(max(k-1, 1)) > center_arr(n)
            przyn_arr(n) = 1;
        else
            for i = 1:n
                przyn_arr(i) = f_przyn(center_arr(i), distance, y(max(k-1, 1)));
            end
        end
        s_u = zeros(size(s_u_arr{1}));
        for i_pole = 1:n
            s_u = s_u + s_u_arr{i_pole} * przyn_arr(i_pole);
        end

        for i = 1:N
            for j = 1:Nu
                if (i-j+1) > 0
                    M(i,j) = s_u(i-j+1);
                end
            end
        end
        % Macierz Mpu
        for i = 1:N
            for j = 1:D-1
                Mp(i,j) = s_u(min(i+j,D)) - s_u(j);
            end
        end

        F1 = F1pp;
        if k - k_delay > 0
            F1 = u(k-k_delay);
        end
        dUp = [];
        [h1, h2, V1, V2, F2, F3] = simulate(h1, h2, FD(k), F1, T);
        y(k) = h2;
        e(k) = yzad(k) - y(k);
        Yzadk = yzad(k) * ones(N, 1);
        Yk = y(k) * ones(N, 1);
        for i = 1:D-1
            dUp = [dUp; u(max(k-i, 1)) - u(max(k-i-1, 1))];
        end
        H = M'*M+lambda*eye(Nu);
        f=-(Yzadk - Yk - Mp * dUp)' * M;
        lb = u_min - u(max(k-1, 1));
        ub = u_max - u(max(k-1, 1));
        dU = quadprog(H, f, A, [-lb * ones(Nu, 1); ub * ones(Nu, 1)], [], []);
        if k - 1 > 0
            u(k) = dU(1) + u(k-1);
        else
            u(k) = dU(1) + F1pp;
        end
   end
end