%parametry
Upp = 0;
Ypp = 0;

kk=800;

D = length(S);
N =30;
Nu =15;

u(1:kk)=Upp; 
y(1:kk)=Ypp;
Z = zeros(1,kk);
e(1:D-1)=0;
lambda = 5;

yzad(1:250)=0;
yzad(251:800)= 5;
t = 0.01*(1:kk);
Z=0.1*sin(2*pi*f*t);

M = zeros(N,Nu);
Mp = zeros(N,D-1);

% Wypełnianie macierzy M i Mp
for i= 1:N
    for j = 1:Nu
        if (i-j+1)>0
            M(i,j) = S(i-j+1);
        end
    end
end

for i = 1:N
    for j = 1:D-1
        Mp(i,j) = S(min(i+j,D)) - S(j);
    end
end

Gamma = eye(N,N);
Alpha = eye(Nu,Nu) * lambda;

K = inv(M' * Gamma * M + Alpha) * M' * Gamma;

E = 0;
for k=D:kk
    y(k) = symulacja_obiektu2y_p2(u(k-5), u(k-6), Z(k-3), Z(k-4), y(k-1), y(k-2));
    e(k)=yzad(k)-y(k);
    E = E + e(k)^2;
    dUp = [];
    for i=1:D-1
        if (k-i-1) > 0
            dUp = [dUp;u(k-i) - u(k-i-1)];
        else
            dUp = [dUp;u(k-i)];
        end
    end
    YzadN = yzad(k) *ones(N,1);
    YkN = y(k) *ones(N,1);
    dU = K*(YzadN - YkN - Mp * dUp);
    u(k)= dU(1) + u(k-1);

end

E

% wykresy
t = linspace(1,kk,kk);
figure; 
stairs(t,u);
plot_data = [t', u'];
save("zadDMC4u_symN"+N+"Nu"+Nu+"D"+D+"LAM"+lambda+".txt","plot_data","-ascii")
title('Przebieg sterowania'); 
xlabel('Numer próbki');
ylabel("Wartość sterowania")
figure; 
stairs(t,y); 
plot_data = [t', y'];
save("zadDMC4y_symN"+N+"Nu"+Nu+"D"+D+"LAM"+lambda+".txt","plot_data","-ascii")
hold on;
stairs(t,yzad);
plot_data = [t', yzad'];
save("zadDMC4yzad_symN"+N+"Nu"+Nu+"D"+D+"LAM"+lambda+".txt","plot_data","-ascii")
title('Przebieg y,y_{zad}'); 
xlabel('Numer próbki');
ylabel('Wartość wyjścia')
legend("Wartość na wyjściu", "Wartość zadana",Location="southeast")