function [u, y, e] = dmc_z_zakloceniem(F1pp,h2pp, h1pp, s_u, s_z, yzad, D,D_z, z, N, Nu, lambda, deltaumax, Umin, Umax)
    % Inicjalizacja wektorów
    kk = length(yzad);
    u = zeros(1, kk);
    y = ones(1, kk) * h2pp;
    e = zeros(1, kk);
    M = zeros(N,Nu);
    Mp = zeros(N,D-1);
    Mp_z = zeros(N,D_z-1);
    Fin(1:kk) = F1pp;
    h1 = h1pp;
    h2 = h2pp;
    % Macierz M
    for i = 1:N
        for j = 1:Nu
            if (i-j+1) > 0
                M(i,j) = s_u(i-j+1);
            end
        end
    end

    % Macierz Mpu
    for i = 1:N
        for j = 1:D-1
            Mp(i,j) = s_u(min(i+j,D)) - s_u(j);
        end
    end
    for i = 1:N
        for j = 2:D_z
            Mp_z(i,j) = s_z(min(i+j-1,D_z)) - s_z(j-1);
        end
    end
    Mp_z(:, 1) = s_z(1:N);
    % Wyznaczenie K i dobranie parametrów kary
    Gamma = eye(N, N);
    Alpha = eye(Nu, Nu) * lambda;
    K = inv(M' * Gamma * M + Alpha) * M' * Gamma;
    T = 1;
    % Inicjalizacja wektora du i współczynników równania różnicowego
    du = zeros(1, 12);
    % Główna pętla regulatora
    for k = 2:kk
        dUp = [];
        du_z = [];
        [h1, h2,Vx1, Vx2,F1x,F2x, F3x] = object_simulation(h1,h2, z(k),Fin,k, F1pp, T);
        y(k) = h2;
        u = Fin;
        e(k) = yzad(k) - y(k);
        Yzadk = yzad(k) * ones(N, 1);
        Yk = y(k) * ones(N, 1);
        for i = 1:D-1
            dUp = [dUp; u(max(k-i, 1)) - u(max(k-i-1, 1))];
        end
        for i = 1:D_z
            du_z = [du_z; z(max(k-i, 1)) - z(max(k-i-1, 1))];
        end
        dU = K * (Yzadk - Yk - Mp * dUp - Mp_z*du_z);
        u(k) = dU(1) + u(k-1);
        Fin = u;
        % % Skalowanie wartości u
        % deltau = u(k) - u(k-1);
        % u(k) = u(k-1) + min(abs(deltau), abs(deltaumax)) * sign(deltau);
        % 
        % % Sprawdzenie czy U znajduje się w przedziale, ew. ścięcie
        % u(k) = max(min(u(k), Umax), Umin);
        % 
        % % Wprowadzenie zmian wartości zadanej
    end
end