addpath('D:\SerialCommunication'); % add a path to the functions
initSerialControl COM9 % initialise com port

%parametry
Upp = 27;
Ypp = 30;
Umin= 0;
Umax = 100;
deltaumax = inf;
D=300;
kk=1000;

N =200;
Nu =10;
S = s;

u=ones(kk,1) * Upp; 
y=ones(kk,1) * Ypp;
yzad=zeros(kk,1);
e(1:D-1)=0;
lambda = 0.15;

Gamma = eye(N,N);
Alpha = eye(Nu,Nu) * lambda;
du = zeros(0:12);

M = zeros(N,Nu);
Mp = zeros(N,D-1);

yzad(1:500)=31.4;
yzad(501:1000) = 41.4;


% Wypełnianie macierzy M i Mp
for i= 1:N
    for j = 1:Nu
        if (i-j+1)>0
            M(i,j) = S(i-j+1);
        end
    end
end

for i = 1:N
    for j = 1:D-1
        Mp(i,j) = S(min(i+j,D)) - S(j);
    end
end

K = inv(M' * Gamma * M + Alpha) * M' * Gamma;
E = 0;

for k=D:kk
    dUp = [];
    y(k) = readMeasurements(1:1);
    disp(k);
    disp(y(k));
    e(k)=yzad(k)-y(k);
    Yzadk = yzad(k) *ones(N,1);
    Yk = y(k) *ones(N,1);
    E = E + e(k)^2;

    for i=1:D-1
        if (k-i-1) > 0
            dUp = [dUp;u(k-i) - u(k-i-1)];
        else
            dUp = [dUp;u(k-i)];
        end
    end
    dU = K*(Yzadk - Yk - Mp * dUp);
    u(k)= dU(1) + u(k-1);

    % Sprawdzenie czy u(k) znajduje się w przedziale
    if u(k) < Umin
        u(k) = Umin;
    end
    if u(k) > Umax
        u(k) = Umax;
    end
    sendControls(5, u(k));
    waitForNewIteration();
    refreshdata
    drawnow
    stairs(y);
    hold on
    stairs(u);
    stairs(yzad);
    hold off;
end

% wykresy
t = 1:length(u);
t = t';
figure; 
stairs(t,u);
plot_data = [t, u];
save("zadDMC4u_sym.txt","plot_data","-ascii")
title('Przebieg sterowania'); 
xlabel('Numer próbki');
ylabel("Wartość sterowania")
figure; 
stairs(t,y); 
plot_data = [t, y];
save("zadDMC4y_sym.txt","plot_data","-ascii")
hold on;
stairs(t,yzad);
plot_data = [t, yzad];
save("zadDMC4yzad_sym.txt","plot_data","-ascii")
title('Przebieg y,y_{zad}'); 
xlabel('Numer próbki');
ylabel('Wartość wyjścia')
legend("Wartość na wyjściu", "Wartość zadana")