%parametry
Upp = 0;
Ypp = 0;

kk=800;

D = length(S);
D_z =length(Sz);
N =30;
Nu =15;

u(1:kk)=Upp; 
y(1:kk)=Ypp;

e(1:D-1)=0;
lambda = 5;

yzad(1:250)=0;
yzad(251:800)= 5;
Z = zeros(1,kk);
Z(401:500) = 1;
Z(501:600) = -1;
Z(601:700) = 0.5;
Z(701:800) = 1;
z = Z;


M = zeros(N,Nu);
Mp = zeros(N,D-1);
Mp_z = zeros(N,D_z-1);

% Wypełnianie macierzy M i Mp
for i= 1:N
    for j = 1:Nu
        if (i-j+1)>0
            M(i,j) = S(i-j+1);
        end
    end
end

for i = 1:N
    for j = 1:D-1
        Mp(i,j) = S(min(i+j,D)) - S(j);
    end
end

for i = 1:N
    for j = 1:D_z-1
        Mp_z(i,j) = Sz(min(i+j,D_z)) - Sz(j);
    end
end

Gamma = eye(N,N);
Alpha = eye(Nu,Nu) * lambda;

K = inv(M' * Gamma * M + Alpha) * M' * Gamma;

E = 0;
for k=D:kk
    y(k) = symulacja_obiektu2y_p2(u(k-5), u(k-6), z(k-3), z(k-4), y(k-1), y(k-2));
    e(k)=yzad(k)-y(k);
    E = E + e(k)^2;
    dUp = [];
    for i=1:D-1
        if (k-i-1) > 0
            dUp = [dUp;u(k-i) - u(k-i-1)];
        else
            dUp = [dUp;u(k-i)];
        end
    end
    dZp = [];
    for i=1:D_z-1
        if (k-i-1) > 0
            dZp = [dZp;z(k-i) - z(k-i-1)];
        else
            dZp = [dZp;z(k-i)];
        end
    end
    YzadN = yzad(k) *ones(N,1);
    YkN = y(k) *ones(N,1);
    dU = K*(YzadN - YkN - Mp * dUp - Mp_z * dZp);
    u(k)= dU(1) + u(k-1);

end

E

% wykresy
t = linspace(1,kk,kk);
figure; 
stairs(t,u);
plot_data = [t', u'];
save("zadDMC4u_symN"+N+"Nu"+Nu+"D"+D+"LAM"+lambda+".txt","plot_data","-ascii")
title('Przebieg sterowania'); 
xlabel('Numer próbki');
ylabel("Wartość sterowania")
figure; 
stairs(t,y); 
plot_data = [t', y'];
save("zadDMC4y_symN"+N+"Nu"+Nu+"D"+D+"LAM"+lambda+".txt","plot_data","-ascii")
hold on;
stairs(t,yzad);
plot_data = [t', yzad'];
save("zadDMC4yzad_symN"+N+"Nu"+Nu+"D"+D+"LAM"+lambda+".txt","plot_data","-ascii")
title('Przebieg y,y_{zad}'); 
xlabel('Numer próbki');
ylabel('Wartość wyjścia')
legend("Wartość na wyjściu", "Wartość zadana",Location="southeast")