#include <ZsutEthernet.h>
#include <ZsutEthernetUdp.h>
#include <ZsutFeatures.h>

#define MAX_BUFFER 256

byte mac[] = {
  0x01, 0xFF, 0xAA, 0x12, 0x34, 0x02
};
ZsutEthernetUDP Udp;
ZsutIPAddress address_ip=ZsutIPAddress(192,168,56,101);
unsigned int localPort = 9994;
unsigned int remotePort = 9998;


unsigned char requestBuffer[MAX_BUFFER] = "\x10\0\0\0\1\x0Btemperature\1\4\0";
int len=0;
bool alarm = false;

void setup() {
  ZsutPinMode(ZSUT_PIN_D4, OUTPUT);
  while (!Serial) {
  }

  ZsutEthernet.begin(mac);
  Serial.println(ZsutEthernet.localIP());
  Serial.println(localPort);
  Udp.begin(localPort);
  
  ZsutDigitalWrite(ZSUT_PIN_D4, LOW);
}

void loop() {
  int value = ZsutAnalog5Read();
  if(value > 50) {
    requestBuffer[19] = true;
  }
  else {
    requestBuffer[19] = false;
  }
  if(alarm != requestBuffer[19]) { // zmiana stanu alarmu
    len = 20;
    Serial.print("Wysylam zmianę stanu alarmu na ");
    Serial.println((int)requestBuffer[19]);
    Udp.beginPacket(address_ip, remotePort);
    int r=Udp.write(requestBuffer, len);
    Udp.endPacket();
  }
  alarm = requestBuffer[19]; //aktualizacja stanu alarmu
  
  delay(100);
}
