#include <Ethernet.h>
#include <EthernetUdp.h>

#define MAX_BUFFER 32

byte mac[] = {
  0x01, 0xFF, 0xAA, 0x12, 0x34, 0x01
};
EthernetUDP Udp;
IPAddress address_ip=IPAddress(192,168,0,40);
unsigned int localPort = 15281;

unsigned char packetBuffer[MAX_BUFFER];

unsigned char sendBuffer[MAX_BUFFER];
int len=0;

void setup() {
  pinMode(2, INPUT);
  Serial.begin(9600);
  while (!Serial) {
  }

  Ethernet.begin(mac);
  Serial.println(Ethernet.localIP());
  Udp.begin(localPort);
  sendBuffer[0] = 'A';
  len = 1;
  Udp.beginPacket(address_ip, localPort);
  int r=Udp.write(sendBuffer, len);
  Udp.endPacket();
}

void loop() {
  bool button = digitalRead(2);
  int packetSize=Udp.parsePacket();
  if(packetSize){
    int r=Udp.read(packetBuffer, MAX_BUFFER);
    if(r == 1 && packetBuffer[0] == 'R') {
      bool button = digitalRead(2);
      sendBuffer[0] = button ? '1' : '0';
      len = 1;
      Udp.beginPacket(address_ip, localPort);
      int r=Udp.write(sendBuffer, len);
      Udp.endPacket();
    }
  }
}
